import UIKit


@IBDesignable class CustomView : UIView
{
    @IBInspectable var borderWidth : CGFloat = 10.0 {
        didSet {
            self.layer.borderWidth = borderWidth
        }
    }
    
    @IBInspectable var cornerRadius : CGFloat = 10.0 {
        didSet {
            self.layer.cornerRadius = cornerRadius
        }
    }
    
    
    override func prepareForInterfaceBuilder()
    {
        self.backgroundColor = UIColor.lightGray
        
        self.layer.borderColor = UIColor.red.cgColor
    }
}






class ViewController: UIViewController {

}

